@echo off
set LOG_DIR=Troubleshooting_temp

REM Get the current date and time in an international format using PowerShell
for /f %%i in ('powershell -Command "Get-Date -Format yyyy-MM-dd_HH-mm-ss"') do set mydatetime=%%i

REM Format the zip file name with the current date and time
set ZIP_FILE=Send_to_devs_%mydatetime%.zip
mkdir %LOG_DIR%

REM Check if the latest_log.log file exists and copy it to the log directory
set LOG_FILE=%appdata%\Necesse\latest-log.txt
if exist %LOG_FILE% (
    echo Copying %LOG_FILE% to %LOG_DIR%...
    copy %LOG_FILE% %LOG_DIR%
) else (
    echo %LOG_FILE% does not exist.
)
echo.

set CRASH_LOG=latest-crash.log
REM Check if the latest_crash.log file exists and copy it to the log directory
if exist %CRASH_LOG% (
    echo Copying %CRASH_LOG% to %LOG_DIR%...
    copy %CRASH_LOG% %LOG_DIR%
) else (
    echo %CRASH_LOG% does not exist.
)
echo.

REM Copy all hs_err_pid files to the log directory
for %%f in (hs_err_pid*.log) do (
    if exist %%f (
        echo Copying %%f to %LOG_DIR%...
        copy %%f %LOG_DIR%
    )
)
echo.

REM Find the most recent .dat or .zip file and save its path to a variable
set SOURCE_DIR=%appdata%\Necesse\saves\worlds
for /f "delims=" %%i in ('powershell -Command "Get-ChildItem -Path %SOURCE_DIR% -Recurse -Include *.dat, *.zip | Sort-Object LastWriteTime -Descending | Select-Object -First 1 -ExpandProperty FullName"') do set LATEST_FILE=%%i
echo The most recent file is: %LATEST_FILE%

if /i "%LATEST_FILE:~-4%"==".zip" (
    set ZIP_WORLD_FILE=TRUE
)

REM Handle world folder and zip world separately.
if defined ZIP_WORLD_FILE (
    echo Copying world zip file: %LATEST_FILE% to "%LOG_DIR%/saves/worlds/"...
    xcopy "%LATEST_FILE%" "%LOG_DIR%\saves\worlds\"
) else (
    REM Get the parent directory of the latest directory
    if defined LATEST_FILE (
        setlocal enabledelayedexpansion
        set "LATEST_FILE=%LATEST_FILE:"=%"
        for /f "delims=" %%F in ("%LATEST_FILE%") do (
            set "WORLD_DIR=%%~dpF"
            for %%I in ("!WORLD_DIR:~0,-1!") do set "WORLD_NAME=%%~nxI"
            echo Copying latest modified folder "!WORLD_DIR!" to "%LOG_DIR%\saves\worlds\!WORLD_NAME!"...
            xcopy "!WORLD_DIR!" "%LOG_DIR%\saves\worlds\!WORLD_NAME!\" /s /e /y
        )
        endlocal
    )else (
        echo No folder with a world.dat file found.
    )
    echo.
)

REM Copy the characters folder if it exists
set CHARACTERS_DIR=%appdata%\Necesse\saves\characters
if exist "%CHARACTERS_DIR%" (
    echo Copying characters folder to "%LOG_DIR%\saves\characters"...
    xcopy "%CHARACTERS_DIR%" "%LOG_DIR%\saves\characters\" /s /e /y
) else (
    echo Characters folder does not exist.
)
echo.

REM Copy the config folder if it exists
set CFG_DIR=%appdata%\Necesse\cfg
if exist "%CFG_DIR%" (
    echo Copying cfg folder to "%LOG_DIR%\cfg"...
    xcopy "%CFG_DIR%" "%LOG_DIR%\cfg\" /s /e /y
) else (
    echo Cfg folder does not exist.
)
echo.

REM Copy the cache folder if it exists
set CACHE_DIR=%appdata%\Necesse\cache
if exist "%CACHE_DIR%" (
    echo Copying cache folder to "%LOG_DIR%\cache"...
    xcopy "%CACHE_DIR%" "%LOG_DIR%\cfg\" /s /e /y
) else (
    echo Cache folder does not exist.
)
echo.

REM Zip the log directory
echo Zipping the log directory...
powershell -Command "Compress-Archive -Path %LOG_DIR%\* -DestinationPath %ZIP_FILE% -Force"
echo.

REM Remove temp log directory
rmdir /s /q  %LOG_DIR% 

echo Logs are saved to %ZIP_FILE%. Send the file to the developers on Discord or to support@necessegame.com.
pause
